// postSceneShadowing_water_flpoint.vsh

uniform mat4 vc0;	// worldViewProj
uniform mat4 vc4;
uniform mat4 vc8;
uniform vec4 vc12;
uniform vec4 vc13;

void main()
{
	// transform position
	gl_Position = gl_Vertex * vc0;

	// Set to constant color
	gl_FrontColor = vec4(0.0, 0.0, 0.0, 0.0);
	
	// transform
	vec4 coord0 = gl_Vertex * vc4;
	gl_TexCoord[0].s = coord0.x;
	gl_TexCoord[0].t = 1.0 - coord0.y;

	// Depth in light space
	vec4 r1 = gl_Vertex * vc8;
	gl_TexCoord[1].s = r1.z * vc12.x;
	
	vec2 temp = gl_Vertex.xz * vc13.x;
	gl_TexCoord[2].s = temp.x * vc13.w + temp.y * -vc13.z - vc13.y;
	gl_TexCoord[2].t = temp.x * vc13.z + temp.y * vc13.w;
}

/*
vs.1.1

def c18, 0.0, 0.0, 0.0, 0.0

dcl_position0 v0

// transform position
m4x4 oPos, v0, c0

// Set to constant color
mov oD0, c18

// Transform
m4x4 oT0, v0, c4

// Depth in light space
m4x4 r1, v0, c8
mul oT1.x, r1.z, c12.x

// Calculate texture coords for bump
//   float2 temp = vPosition.xz * texMtxParams.x;// / 16.0f;
//   float2 bumpCoords;
//   bumpCoords.x = temp.x * texMtxParams.w + temp.y * -texMtxParams.z - texMtxParams.y;//-time * 1;// + time * 0;
//   bumpCoords.y = temp.x * texMtxParams.z + temp.y * texMtxParams.w;// + time;
//   Output.TexCoord0 = bumpCoords;
mul r2.xy, v0.xz, c13.x
mul r1.xyz, r2.xxy, c13.wzw
mad r0.w, r2.y, -c13.z, r1.x
add oT2.x, r0.w, -c13.y
add oT2.y, r1.y, r1.z
*/